
FullName='黄蔚葳';
SimplyName='hww';
i_sub=10;

%% 一、预处理
CreateFolder(FullName);  % 创建所需数据的文件夹列表；
% 【1】功能数据预处理：将原始数据（电生理/行为放至指定文件夹 被试名_data/处理数据集文件夹下）
VAESub(SimplyName,FullName);
% VAESub_huaxi(SimplyName,FullName);
MergeSession(FullName);

% 【2】影像数据预处理：手动操作
% 1.在SPM中CT和MRI文件转格式至nfti文件；
% 2. CT与MRI配准；
% 3. Freesurfer皮层分割; E\ImageData
% 4.在3D slicer中确认电极位置/名称，剪切至EXCEL->LOC(位点名称、XYZ，txt)文件中；
%   在Brainstorm软件中导入FreeSurfer皮层重建文件夹和CT（Core/reslice）,然后Y右击CT图像->
%    SEEG/ECOG implantation->添加电极，设定参数—>导出为EEG/NIRS：Name/XYZ.World文件

% 【3】4种条件数据/电极位置导入Brainstorm软件中：手动操作
% 1.导入影像数据（Freesurfer分割文件夹）,完成后右击MRI->MNI norm->Segment %后导入的话电极坐标系可能不太对；
% 2.创建不同条件文件夹，import EEG，打开channel文件，右击set channel type改为SEEG；
% 3.右击channel文件，add EEG positions——>import from file，导入文件类型为...
%   EEG|ASCII|Name.xyz_World->LOC文件,弹窗选择1mm
BipolarRef_BST(SimplyName);  % 3. 双极参考
% 4.电极定位: BST中 iEEG atlas labels ->输出，选择所有高分辨率图谱/surface，...
% 输出至 电极位置 文件夹；将tsv文件中内容拷贝到名为'电极脑区'的txt文件中；

%% 二、单个被试数据分析

BST_BatchProcess_TimeFreq(SimplyName);  %时频分析；Spectrogram-AVG和Group Magnitude；
PLV_BST_BatchProcess(SimplyName) ;           % 计算两种条件下PLV（调用BST）

RTepochT_ERP = LatDe_ERP_sub(SimplyName,FullName);  % 单个位点ERP分析，画图；
RTepochT_freq = LatDe_TimeFreq_sub(SimplyName,FullName); % 单个位点TimeFreq分析，画图；
DOTAnatomy1 = GroupInTable(SimplyName,FullName,i_sub);  %将 DOT/DOT_HG等特征值整合进表格；
Cri_Chan = Select_chan(DOTAnatomy1);        % 筛选出符合分析需求的位点(所有被试)
perfT = DecodingAna(SimplyName,FullName,Cri_Chan);    % 用ROI区域内的位点decoding
PLV_Ana(SimplyName,FullName);               % PLV按脑区排序/画图

%% 三、被试汇总数据分析

 [SimplyNameT,FullNameT] = ExtractSubName;
 MatrixData_plv = GroupAna_plv(SimplyNameT,FullNameT);
 DispInBrainNet(MatrixData_plv);
 AE_t = GroupElectrodes(SimplyNameT,FullNameT);  % 手动将chanfile->project...
 % to default anatomy，然后确认GroupChannel中有被试名字_@intra文件夹，将AE_t...
 % 导入BST的Groupchannel中 %(暂时不需)需手动删除坏电极（lr，bxz，5个）；
 [fileExport] = DispAvgGroup(SimplyNameT,FullNameT);   %将平均数据
 % 展示在BST中,4个结果（HG/ERP X epoch masked/DOT）保存在指定位置Result.mat中,...
 % 需要手动替换；还需完善细节; % 1,HG;2,ERP
PopulationResult(Cri_Chan);  %汇总HG和ERP符合条件的位点结果；
DecodingResult_pop(SimplyNameT,FullNameT);  % 汇总解码结果
SpectrogramAna; %汇总频谱图；不是函数，需要改进；


%% 行为数据汇总分析
ContrastAna_function(SimplyNameT,FullNameT);
VAMSub;  % 需添加'E:\DataAnaProgram\行为分析'至matlab路径
psyCurvePlot_MSub; % 脚本,按照情况修改，需改结果文件夹名字后缀beh1；